/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.XMLHelper;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class VWStringUtils {
    private static final String ENCODING = "UTF-8";
    private static final int DEFAULT_WRAP_POSITION = 60;
    private static Collator m_collator = Collator.getInstance();

    public static int compare(String string1, String string2) {
        if (string1 == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        return m_collator.compare(string1, string2);
    }

    public static boolean compareUsers(VWSession session, String string1, String string2) {
        if (string1 == null || string2 == null) {
            return false;
        }
        try {
            if (session != null) {
                return session.convertUserNameToId(string1) == session.convertUserNameToId(string2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public static boolean compareUsers(String string1, String string2) {
        if (string1 == null || string2 == null) {
            return false;
        }
        try {
            VWSession vwSession = VWDefaultSessionProxy.getSession();
            if (vwSession != null) {
                return VWStringUtils.compareUsers(vwSession, string1, string2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public static int compareIgnoreCase(String string1, String string2) {
        if (string1 == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        string1 = string1.toLowerCase();
        string2 = string2.toLowerCase();
        return m_collator.compare(string1, string2);
    }

    public static Dimension stringToDimension(String sDim) {
        Exception e = null;
        StringTokenizer st = new StringTokenizer(sDim, ",;\t ");
        String sw = null;
        String sh = null;
        if (st.hasMoreTokens()) {
            sw = st.nextToken();
            if (st.hasMoreTokens() && (sh = st.nextToken()) != null && sw != null) {
                try {
                    int width = Integer.valueOf(sw);
                    int height = Integer.valueOf(sh);
                    return new Dimension(width, height);
                }
                catch (NumberFormatException ex) {
                    e = ex;
                }
            }
        }
        if (e == null) {
            e = new Exception();
        }
        VWDebug.logException(e, VWResource.s_invalidDimensionFormat.toString(sDim));
        return null;
    }

    public static String dimensionToString(Dimension dim) {
        if (dim == null) {
            return null;
        }
        return Integer.toString(dim.width) + ";" + Integer.toString(dim.height);
    }

    public static String dimensionToString(int width, int height) {
        return Integer.toString(width) + ";" + Integer.toString(height);
    }

    public static String mnemonicToString(char mnemonic) {
        char[] c = new char[]{mnemonic};
        return new String(c);
    }

    public static String mnemonicToString(int mnemonic) {
        return VWStringUtils.mnemonicToString((char)mnemonic);
    }

    public static char stringToMnemonic(String s) {
        if (s == null || s.length() == 0) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public static String[] getResourcesFromString(String stringResource) {
        if (stringResource == null) {
            return null;
        }
        String[] resources = new String[2];
        int nIndex = stringResource.indexOf("&");
        if (nIndex != -1) {
            resources[1] = stringResource.substring(nIndex + 1, nIndex + 2);
            if (nIndex > 0) {
                resources[0] = stringResource.substring(0, nIndex);
                resources[0] = resources[0].concat(stringResource.substring(nIndex + 1));
            } else {
                resources[0] = stringResource.substring(nIndex + 1);
            }
        } else {
            resources[0] = stringResource;
        }
        return resources;
    }

    public static JMenu getMenuUsingString(String stringResource) {
        String[] resources = VWStringUtils.getResourcesFromString(stringResource);
        if (resources == null) {
            return null;
        }
        JMenu newMenu = new JMenu(resources[0]);
        if (newMenu != null && resources[1] != null && resources[1].length() > 0) {
            newMenu.setMnemonic(resources[1].charAt(0));
        }
        return newMenu;
    }

    public static JMenuItem getMenuItemUsingString(String stringResource) {
        String[] resources = VWStringUtils.getResourcesFromString(stringResource);
        if (resources == null) {
            return null;
        }
        JMenuItem newMenuItem = new JMenuItem(resources[0]);
        if (newMenuItem != null && resources[1] != null && resources[1].length() > 0) {
            newMenuItem.setMnemonic(resources[1].charAt(0));
        }
        return newMenuItem;
    }

    public static JCheckBoxMenuItem getCheckBoxMenuItemUsingString(String stringResource) {
        String[] resources = VWStringUtils.getResourcesFromString(stringResource);
        if (resources == null) {
            return null;
        }
        JCheckBoxMenuItem newMenuItem = new JCheckBoxMenuItem(resources[0]);
        if (newMenuItem != null && resources[1] != null && resources[1].length() > 0) {
            newMenuItem.setMnemonic(resources[1].charAt(0));
        }
        return newMenuItem;
    }

    public static JRadioButtonMenuItem getRadioButtonMenuItemUsingString(String stringResource) {
        String[] resources = VWStringUtils.getResourcesFromString(stringResource);
        if (resources == null) {
            return null;
        }
        JRadioButtonMenuItem newMenuItem = new JRadioButtonMenuItem(resources[0]);
        if (newMenuItem != null && resources[1] != null && resources[1].length() > 0) {
            newMenuItem.setMnemonic(resources[1].charAt(0));
        }
        return newMenuItem;
    }

    public static JButton getButtonUsingString(String stringResource) {
        String[] resources = VWStringUtils.getResourcesFromString(stringResource);
        if (resources == null) {
            return null;
        }
        JButton newButton = new JButton(resources[0]);
        if (newButton != null && resources[1] != null && resources[1].length() > 0) {
            newButton.setMnemonic(resources[1].charAt(0));
        }
        return newButton;
    }

    public static JLabel getLabelUsingString(String stringResource) {
        String[] resources = VWStringUtils.getResourcesFromString(stringResource);
        if (resources == null) {
            return null;
        }
        JLabel newLabel = new JLabel(resources[0]);
        if (newLabel != null && resources[1] != null && resources[1].length() > 0) {
            newLabel.setDisplayedMnemonic(resources[1].charAt(0));
        }
        return newLabel;
    }

    public static String formatToolTip(String tooltip, int nWrapPosition) {
        if (tooltip != null && tooltip.length() > 0) {
            String tempString = VWStringUtils.toXMLString(tooltip, false);
            if (tempString == null || tempString.length() == 0) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            String[] pieces = tempString.split("&#10;");
            for (int nIndex = 0; nIndex < pieces.length; ++nIndex) {
                if (buffer.length() > 0) {
                    buffer.append("<BR>");
                }
                buffer.append(VWStringUtils.formatSingleLine(pieces[nIndex], nWrapPosition));
            }
            if (buffer.length() != 0) {
                tempString = buffer.toString();
            }
            return "<html>" + tempString + "</html>";
        }
        return null;
    }

    public static String formatXMLToolTip(String tooltip, int nWrapPosition) {
        if (tooltip != null && tooltip.length() > 0) {
            String tempString = VWStringUtils.toXMLString(tooltip, true);
            if (tempString == null || tempString.length() == 0) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            String[] pieces = tempString.split("&#10;");
            for (int nIndex = 0; nIndex < pieces.length; ++nIndex) {
                if (buffer.length() > 0) {
                    buffer.append("<BR>");
                }
                buffer.append(VWStringUtils.formatSingleLine(pieces[nIndex], nWrapPosition));
            }
            if (buffer.length() != 0) {
                tempString = buffer.toString();
            }
            tempString = VWStringUtils.replaceAll(tempString, " ", "&nbsp;");
            tempString = VWStringUtils.replaceAll(tempString, "&#09;", "&nbsp;&nbsp;&nbsp;&nbsp;");
            return "<html>" + tempString + "</html>";
        }
        return null;
    }

    public static String xmlPrettyFormat(String xmlString) throws Exception {
        String resultString = xmlString;
        Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(xmlString)), null, null, false, false);
        if (doc != null && (resultString = VWStringUtils.docToString(doc)) != null && xmlString.indexOf("<?xml") == -1 && resultString.indexOf("<?xml") != -1) {
            int index = resultString.indexOf("?>");
            index = resultString.indexOf("<", index);
            resultString = resultString.substring(index, resultString.length());
        }
        if (resultString != null) {
            resultString = resultString.trim();
        }
        return resultString;
    }

    public static String replaceAll(String sourceStr, String regex, String replacement) {
        if (sourceStr == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        int nIndex0 = 0;
        int nIndex1 = sourceStr.indexOf(regex, nIndex0);
        while (nIndex1 != -1) {
            strBuffer.append(sourceStr.substring(nIndex0, nIndex1));
            strBuffer.append(replacement);
            nIndex0 = nIndex1 + regex.length();
            nIndex1 = sourceStr.indexOf(regex, nIndex0);
        }
        strBuffer.append(sourceStr.substring(nIndex0));
        return strBuffer.toString();
    }

    public static String toXMLString(String buf, boolean bIncludeSingleQuote) {
        if (buf == null) {
            return "";
        }
        boolean bSpecialChar = false;
        block14: for (int i = 0; i < buf.length() && !bSpecialChar; ++i) {
            switch (buf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    bSpecialChar = true;
                    continue block14;
                }
                case '\'': {
                    if (!bIncludeSingleQuote) continue block14;
                    bSpecialChar = true;
                }
            }
        }
        if (!bSpecialChar) {
            return buf;
        }
        StringBuffer sb = new StringBuffer();
        block15: for (int i = 0; i < buf.length(); ++i) {
            switch (buf.charAt(i)) {
                case '&': {
                    sb.append("&amp;");
                    continue block15;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block15;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block15;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block15;
                }
                case '\n': {
                    sb.append("&#10;");
                    continue block15;
                }
                case '\r': {
                    sb.append("&#13;");
                    continue block15;
                }
                case '\t': {
                    sb.append("&#09;");
                    continue block15;
                }
                case '\'': {
                    if (bIncludeSingleQuote) {
                        sb.append("&apos;");
                        continue block15;
                    }
                }
                default: {
                    sb.append(buf.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static String formatSingleLine(String tooltip, int nWrapPosition) {
        int nWrapPos = 60;
        if (nWrapPosition > 0) {
            nWrapPos = nWrapPosition;
        }
        if (tooltip != null) {
            if (tooltip.length() <= nWrapPos) {
                return tooltip;
            }
            String tempString = tooltip;
            StringBuffer buffer = new StringBuffer();
            while (tempString.length() > nWrapPos) {
                int idx;
                int lastIndex = 0;
                boolean found = false;
                boolean foundTag = false;
                if (tempString != null && tempString.length() > nWrapPos && tempString.charAt(nWrapPos) != ' ' && (idx = tempString.lastIndexOf(" ")) > 0) {
                    while (nWrapPos > 0 && tempString.charAt(nWrapPos) != ' ') {
                        --nWrapPos;
                    }
                    ++nWrapPos;
                }
                String x = tempString.substring(0, nWrapPos);
                for (int i = x.length() - 1; i > 0; --i) {
                    if (x.charAt(i) != '&') continue;
                    foundTag = true;
                    for (int j = lastIndex = i; j < nWrapPos; ++j) {
                        if (x.charAt(j) != ';') continue;
                        found = true;
                        lastIndex = nWrapPos;
                        break;
                    }
                    if (found) break;
                    lastIndex = i;
                    break;
                }
                if (!foundTag) {
                    lastIndex = nWrapPos;
                }
                nWrapPos = 60;
                buffer.append(tempString.substring(0, lastIndex) + "<BR>");
                tempString = tempString.substring(lastIndex, tempString.length());
            }
            buffer.append(tempString);
            return buffer.toString();
        }
        return null;
    }

    private static String docToString(Document doc) {
        if (doc != null) {
            OutputFormat format = new OutputFormat(doc);
            format.setEncoding(ENCODING);
            format.setIndenting(true);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            try {
                serial.asDOMSerializer();
                serial.serialize(doc);
            }
            catch (IOException ex) {
                VWDebug.logException(ex);
            }
            String result = stringOut.toString();
            stringOut.getBuffer().delete(0, stringOut.getBuffer().length() - 1);
            return result.trim();
        }
        return "";
    }
}

